<?php

class Ultimate_AI_Category
{
  private $taxonomy = 'ultimate_ai_category_taxonomy';
  private $taxonomy_meta_key = 'ultimate_ai_category_taxonomy_meta_key';

  // ======== Create a new category =======
  public function create_category($name, $desc, $tools, $cat_id)
  {
    $category_args = ['description' => $desc, 'tools' => $tools, "is_active" => true];

    if ($cat_id != 0) {
      wp_update_term($cat_id, $this->taxonomy, ["name" => $name]);
      $term = get_term_meta($cat_id, $this->taxonomy_meta_key, true);
      $category_args["is_active"] = $term["is_active"];
    } else {
      $existing_category = term_exists($name, $this->taxonomy);
      if ($existing_category) return ['success' => false, 'message' => 'Category already exists'];
      $category = wp_insert_term($name, $this->taxonomy);
      if (is_wp_error($category)) return ['success' => false, 'message' => $category->get_error_message()];
      $cat_id = $category["term_id"];
    }

    update_term_meta($cat_id, $this->taxonomy_meta_key, $category_args);
    $category_args["id"] = $cat_id;
    return ['success' => true,  'data' => $category_args];
  }

  public function update_meta_field($id, $field, $value)
  {
    $term = get_term_meta($id, $this->taxonomy_meta_key, true);
    $term[$field] = $value;
    update_term_meta($id, $this->taxonomy_meta_key, $term);
    return $term;
  }

  // ========== Read all category =========
  public function read_all_categories()
  {
    $categories = get_terms([
      'taxonomy' => $this->taxonomy,
      'hide_empty' => false,
      'orderby' => "modified",
      'order'  => "DESC"
    ]);

    if (!empty($categories) && !is_wp_error($categories)) {
      $formattedCategories = array_map(function ($category) {
        $category_meta = get_term_meta($category->term_id, $this->taxonomy_meta_key, true);

        return [
          'id' => $category->term_id,
          'name' => $category->name,
          'description' => $category_meta["description"] ?? "",
          'tools' => $category_meta['tools'] ?? [],
          'is_active'  => $category_meta["is_active"] ?? false
        ];
      }, $categories);

      return ['success' => true, 'categories' => $formattedCategories];
    }

    return ['success' => false, 'message' => 'No categories found.'];
  }

  // ========== Delete Category =========================
  public function delete_category($category_id)
  {
    $existing_category = term_exists($category_id, $this->taxonomy);

    if (!$existing_category) {
      return ['success' => false, 'message' => 'Category not found with ID: ' . $category_id];
    }

    $deleted = wp_delete_term($category_id, $this->taxonomy);

    if (is_wp_error($deleted)) {
      return ['success' => false, 'message' => $deleted->get_error_message()];
    } else {
      return [
        'success' => true,
        'message' => 'Successfully deleted category',
      ];
    }
  }
}
